#include <stdio.h>
#include <mpi.h>
#include <malloc.h>

#define COUNT 3
//#define BUF_SIZE 100
#define MAX_BUF_SIZE 100000 
int  main(int argc, char **argv )
{
	int myid, numprocs;
  	int *all,*ids;
 	MPI_Status status;
  	char name[MPI_MAX_PROCESSOR_NAME];
  	int len;
  	int left, right;
  	MPI_Status  stat[2];
  	MPI_Request request[2];
  	void *r_buf, *s_buf;
  	char err_str[MPI_MAX_ERROR_STRING];
  	int ierr = 0, err_str_len;
	int msg_size;

  	MPI_Init(&argc, &argv);
  	MPI_Comm_size(MPI_COMM_WORLD, &numprocs);
  	MPI_Comm_rank(MPI_COMM_WORLD, &myid); 
  	MPI_Get_processor_name(name, &len);
	
	if ( argc != 2 )
        {
		if( myid == 0 )
		{ 
    			fprintf(stderr, "usage :  ./exchange msg_size\n");
		}
	
		MPI_Finalize();
                return 0;
        }
                                                                                                                            
        msg_size = atoi(argv[1]);
        if(msg_size > MAX_BUF_SIZE)
        {
                if(myid == 0)
                {
                        fprintf(stderr, "Maximum message size is %d\n", MAX_BUF_SIZE);
                }
                MPI_Finalize();
                return 0;
        }

	if( (r_buf = (void *)malloc(msg_size)) == NULL )
  	{
          	fprintf(stderr,"Memory allocation error\n");
          	MPI_Abort(MPI_COMM_WORLD, MPI_ERR_INTERN );
          	exit(1);
  	}

  	if( (s_buf = (void *)malloc(msg_size)) == NULL )
  	{
          	fprintf(stderr,"Memory allocation error\n");
          	MPI_Abort(MPI_COMM_WORLD, MPI_ERR_INTERN );
          	exit(1);
  	}

  	memset(s_buf, 0, msg_size);
  	sprintf(s_buf, "From rank %d\n", myid); 
  
  	if(myid < numprocs-1)   right  = myid+1;
  	if(myid > 0)            left   = myid-1;

  	if(myid == numprocs-1)  right  = 0;
  	if(myid == 0)           left   = numprocs-1 ;

  	ierr= MPI_Isend(s_buf,msg_size,MPI_CHAR,
                  right,1,MPI_COMM_WORLD,&request[0]);

  	if( ierr != MPI_SUCCESS)
  	{
    		MPI_Error_string(ierr, err_str, &err_str_len);
    		fprintf(stderr,"%s\n",err_str);
    		MPI_Abort(MPI_COMM_WORLD, ierr );
    		exit(1);
  	}

  	ierr= MPI_Isend(s_buf,msg_size,MPI_CHAR,
                  left ,1,MPI_COMM_WORLD,&request[1]);
  
  	if( ierr != MPI_SUCCESS)
  	{
    		MPI_Error_string(ierr, err_str, &err_str_len);
    		fprintf(stderr,"%s\n",err_str);
    		MPI_Abort(MPI_COMM_WORLD, ierr );
    		exit(1);
  	}

  	ierr= MPI_Recv( r_buf,msg_size,MPI_CHAR,
                  left ,1,MPI_COMM_WORLD,stat);

  	if( ierr != MPI_SUCCESS)
 	{
    		MPI_Error_string(ierr, err_str, &err_str_len);
    		fprintf(stderr,"%s\n",err_str);
    		MPI_Abort(MPI_COMM_WORLD, ierr );
    		exit(1);
  	}

  	ierr= MPI_Recv( r_buf,msg_size,MPI_CHAR,
                  right,1,MPI_COMM_WORLD,stat);

  	if( ierr != MPI_SUCCESS)
  	{
    		MPI_Error_string(ierr, err_str, &err_str_len);
    		fprintf(stderr,"%s\n",err_str);
    		MPI_Abort(MPI_COMM_WORLD, ierr );
    		exit(1);
 	}

  	ierr= MPI_Waitall(2,request,stat);

  	if( ierr != MPI_SUCCESS)
  	{
    		MPI_Error_string(ierr, err_str, &err_str_len);
    		fprintf(stderr,"%s\n",err_str);
    		MPI_Abort(MPI_COMM_WORLD, ierr );
    		exit(1);
  	}

  	printf("%d finished.\n", myid);
  	MPI_Barrier(MPI_COMM_WORLD);

  	if(myid == 0)
  	{
    		printf("Exchange finished successfully.\n");
  	}

  	MPI_Finalize();
}
